package com.sample.introtoandroid.filestreamofconsciousness;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;


public class ViewLogActivity extends AppCompatActivity {
    public static final String LOG_FILENAME = "Chat_Log.txt";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_view_log);

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        assert getSupportActionBar() != null;
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        final TextView log = (TextView) findViewById(R.id.TextViewCurrentLogFile);

        // Odczyt pliku i wyświetlenie jego zawartości w kontrolce TextView.
        try {
            InputStream iFile = openFileInput(LOG_FILENAME);
            log.setText(inputStreamToString(iFile));
        } catch (Exception e) {
            log.setText("Couldn't read log file.");
        }

        // Obsługa przycisku Wyślij
        final Button clearLog = (Button) findViewById(R.id.ButtonClearLog);
        clearLog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // Jeśli plik istnieje, to go usuwamy.
                if (java.util.Arrays.binarySearch(fileList(), LOG_FILENAME) != (-1)) {
                    deleteFile(LOG_FILENAME);
                }

                // aktualizacja ekranu
                final TextView log = (TextView) findViewById(R.id.TextViewCurrentLogFile);
                log.setText(null);
            }
        });

    }

    // Metoda konwertuje strumień wejściowy na łańcuch znaków, dzięki czemu możemy go 
    // wyświetlić w kontrolce TextView.
    // Zazwyczaj operacje tego typu, potencjalnie długotrwałe, są wykonywane w odrębnych wątkach,
    // a w interfejsie użytkownika jest prezentowany pasek postępów pokazujący proces wczytywania
    // pliku do pamięci. Jednak ten przykład z założenia ma być jak najprostszy, gdyż dziennik 
    // naszej pogawędki jest niewielki. Przykład wykorzystania innego wątku do wykonywania działań
    // tego typu można znaleźć w pliku  FileStreamOfConsciousness.java, a konkretnie 
    // w metodzie logChatMessage().
    public String inputStreamToString(InputStream is) throws IOException {
        StringBuffer sBuffer = new StringBuffer();
        BufferedReader dataIO = new BufferedReader(new InputStreamReader(is));
        String strLine;

        while ((strLine = dataIO.readLine()) != null) {
            sBuffer.append(strLine);
            sBuffer.append("\n");
        }

        dataIO.close();
        is.close();

        return sBuffer.toString();
    }
}
